/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeJEI;

public class SqueezerRecipeCategory
implements IRecipeCategory<SqueezerRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("integrateddynamicscompat", "squeezer");
    private static final int INPUT_SLOT = 0;
    private static final int FLUIDOUTPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic arrowDrawable;

    public SqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/squeezer_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER));
        this.arrowDrawable = guiHelper.createDrawable(resourceLocation, 41, 32, 12, 2);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends SqueezerRecipeJEI> getRecipeClass() {
        return SqueezerRecipeJEI.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent(RegistryEntries.BLOCK_SQUEEZER.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SqueezerRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItem());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems().stream().map(RecipeSqueezer.IngredientChance::getIngredientFirst).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, SqueezerRecipeJEI recipe, IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, true, 1, 17);
        int offset = 0;
        for (i = 0; i < recipe.getOutputItems().size(); ++i) {
            recipeLayout.getItemStacks().init(2 + i, false, 75 + (i % 2 > 0 ? 22 : 0), 7 + offset + (i > 1 ? 22 : 0));
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex >= 2 && slotIndex < 2 + recipe.getOutputItems().size()) {
                float chance = ((RecipeSqueezer.IngredientChance)recipe.getOutputItems().get(slotIndex - 2)).getChance();
                tooltip.add(new TextComponent("Chance: " + chance * 100.0f + "%").m_130940_(ChatFormatting.GRAY));
            }
        });
        if (!recipe.getInputItem().isEmpty()) {
            recipeLayout.getItemStacks().set(0, recipe.getInputItem());
        }
        i = 0;
        for (RecipeSqueezer.IngredientChance outputItem : recipe.getOutputItems()) {
            recipeLayout.getItemStacks().set(2 + i++, outputItem.getIngredientFirst());
        }
        recipeLayout.getFluidStacks().init(1, false, 98, 30, 16, 16, 1000, false, null);
        if (!recipe.getOutputFluid().isEmpty()) {
            recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
        }
    }

    public void draw(SqueezerRecipeJEI recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        int height = (int)(Minecraft.m_91087_().f_91073_.m_46467_() / 4L % 7L);
        this.arrowDrawable.draw(matrixStack, 41, 18 + height * 2);
    }
}

